/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.blockentity.StoveBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.FluidRegistry;

public class TeapotBlockEntity
extends SyncedBlockEntity {
    private final LazyOptional<FluidTank> fluidTank = LazyOptional.of(this::createFluidHandler);
    private final int capacity;

    public TeapotBlockEntity(int capacity, BlockPos pos, BlockState state) {
        super(TeapotBlockEntity.getTeapotTileEntityType(capacity), pos, state);
        this.capacity = capacity;
    }

    public static BlockEntityType<?> getTeapotTileEntityType(int capacity) {
        if (capacity == 2000) {
            return (BlockEntityType)BlockEntityRegister.IRON_KETTLE_TYPE.get();
        }
        return (BlockEntityType)BlockEntityRegister.TEAPOT_TYPE.get();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.m_58901_() && ForgeCapabilities.FLUID_HANDLER.equals(cap)) {
            return this.fluidTank.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fluidTank.ifPresent(f -> f.readFromNBT(tag.m_128469_("FluidTank")));
    }

    protected void m_183515_(CompoundTag tag) {
        this.fluidTank.ifPresent(f -> tag.m_128365_("FluidTank", (Tag)f.writeToNBT(new CompoundTag())));
        super.m_183515_(tag);
    }

    private FluidTank createFluidHandler() {
        return new FluidTank(this.capacity){

            protected void onContentsChanged() {
                TeapotBlockEntity.this.inventoryChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return !stack.getFluid().getFluidType().isLighterThanAir() && stack.getFluid().getFluidType().getTemperature() < 500;
            }
        };
    }

    public FluidTank getFluidTank() {
        return (FluidTank)this.fluidTank.orElse((Object)new FluidTank(0));
    }

    public Fluid getFluid() {
        return this.fluidTank.map(f -> f.getFluid().getFluid()).orElse(Fluids.f_76191_);
    }

    public int getFluidAmount() {
        return this.getFluidTank().getFluidAmount();
    }

    public void setFluidTank(FluidStack stack) {
        this.fluidTank.ifPresent(f -> f.setFluid(stack));
    }

    public void setFluid(Fluid fluid) {
        this.fluidTank.ifPresent(f -> f.setFluid(new FluidStack(fluid, this.getFluidAmount())));
        this.inventoryChanged();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TeapotBlockEntity teapotBlockEntity) {
        if (teapotBlockEntity.getFluidTank().getFluid().isEmpty()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
        if (!(blockEntity instanceof StoveBlockEntity)) {
            return;
        }
        StoveBlockEntity stoveTileEntity = (StoveBlockEntity)blockEntity;
        if (!stoveTileEntity.isBurning()) {
            return;
        }
        if (teapotBlockEntity.getFluidTank().getFluid().getFluid() == Fluids.f_76193_) {
            TeapotBlockEntity.toNextFluid(level, teapotBlockEntity.getFluidTank(), (FlowingFluid)FluidRegistry.WARM_WATER_STILL.get());
        } else if (teapotBlockEntity.getFluidTank().getFluid().getFluid() == FluidRegistry.WARM_WATER_STILL.get()) {
            TeapotBlockEntity.toNextFluid(level, teapotBlockEntity.getFluidTank(), (FlowingFluid)FluidRegistry.HOT_WATER_60_STILL.get());
        } else if (teapotBlockEntity.getFluidTank().getFluid().getFluid() == FluidRegistry.HOT_WATER_60_STILL.get()) {
            TeapotBlockEntity.toNextFluid(level, teapotBlockEntity.getFluidTank(), (FlowingFluid)FluidRegistry.HOT_WATER_80_STILL.get());
        } else if (teapotBlockEntity.getFluidTank().getFluid().getFluid() == FluidRegistry.HOT_WATER_80_STILL.get()) {
            TeapotBlockEntity.toNextFluid(level, teapotBlockEntity.getFluidTank(), (FlowingFluid)FluidRegistry.BOILING_WATER_STILL.get());
        }
    }

    private static void toNextFluid(Level level, FluidTank fluidTank, @NotNull FlowingFluid flowingFluid) {
        FluidStack fluidStack;
        if (level.m_213780_().m_188503_(150) == 0 && (fluidStack = fluidTank.drain(fluidTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE)).getAmount() > 0) {
            fluidTank.fill(new FluidStack((Fluid)flowingFluid, fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

